package ru.yandex.reminders.logic.sup;

import lombok.Data;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

@Data
@BenderBindAllFields
public class XivaPushRequest {

    private final Payload payload;

    public static XivaPushRequest of(XivaPushRequest.Reminder data) {
        return new XivaPushRequest(new Payload(data));
    }

    @Data
    @BenderBindAllFields
    public static class Payload {
        private final Reminder reminder;
    }

    @Data
    @BenderBindAllFields
    public static class Reminder {
        private final String uri;
    }
}
