package ru.yandex.reminders.logic.tv;

import ru.yandex.bolts.function.Function;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderWrapper;
import ru.yandex.misc.lang.DefaultObject;

@Bendable
@BenderWrapper
public class TvProgramId extends DefaultObject {
    private final long id;

    public TvProgramId(long id) {
        this.id = id;
    }

    public static TvProgramId fromEventExternalId(String externalId) {
        return new TvProgramId(Long.parseLong(externalId));
    }

    public static Function<TvProgramId, String> toEventExternalIdF() {
        return TvProgramId::toEventExternalId;
    }

    public long getId() {
        return id;
    }

    public String toEventExternalId() {
        return Long.toString(id);
    }
}
