package ru.yandex.reminders.logic.tv;

import org.joda.time.DateTime;
import ru.yandex.bolts.function.Function;

public class TvReminder {
    private final TvProgramId programId;
    private final TvChannelId channelId;

    private final DateTime eventDate;
    private final int offsetMinute;
    private final String message;

    public TvReminder(TvProgramId programId, TvChannelId channelId,
                      DateTime eventDate, int offsetMinute, String message) {
        this.programId = programId;
        this.channelId = channelId;
        this.eventDate = eventDate;
        this.offsetMinute = offsetMinute;
        this.message = message;
    }

    public static Function<TvReminder, TvChannelProgramId> getChannelProgramIdF() {
        return reminder -> new TvChannelProgramId(reminder.getProgramId(), reminder.getChannelId());
    }

    public TvProgramId getProgramId() {
        return programId;
    }

    public TvChannelId getChannelId() {
        return channelId;
    }

    public DateTime getEventDate() {
        return eventDate;
    }

    public int getOffsetMinute() {
        return offsetMinute;
    }

    public String getMessage() {
        return message;
    }
}
