package ru.yandex.reminders.logic.tv;

import org.joda.time.DateTime;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.misc.lang.Validate;
import ru.yandex.reminders.logic.event.EventId;
import ru.yandex.reminders.logic.event.SpecialClientIds;
import ru.yandex.reminders.logic.reminder.Channel;
import ru.yandex.reminders.logic.reminder.Reminder;
import ru.yandex.reminders.logic.reminder.ReminderWithEvent;

public class TvReminderDataConverter {

    public static Reminder toReminder(TvReminder reminder) {
        DateTime sendDate = reminder.getEventDate().plusMinutes(reminder.getOffsetMinute());
        return Reminder.sms(
                sendDate, Option.of(reminder.getOffsetMinute()),
                Option.empty(), Option.empty(),
                Option.of(reminder.getMessage()));
    }

    public static Reminder changeOffset(Reminder reminder, int offsetMinutes) {
        Validate.equals(Channel.SMS, reminder.getChannel());
        Validate.some(reminder.getEventDate());

        return Reminder.sms(
                reminder.getEventDate().get().plusMinutes(offsetMinutes), Option.some(offsetMinutes),
                reminder.getOrigin(), reminder.getPhone(), reminder.getText());
    }

    public static TvReminder fromReminderWithEvent(ReminderWithEvent reminder) {
        return fromReminderWithEventId(reminder.getReminder(), reminder.getEvent().getId());
    }

    public static TvReminder fromReminderWithEventId(Reminder reminder, EventId id) {
        Validate.equals(SpecialClientIds.TV, id.getCid());

        return new TvReminder(
                TvProgramId.fromEventExternalId(id.getExtId()),
                new TvChannelId(id.getIdx()),
                reminder.getEventDate().get(),
                reminder.getOffset().get(),
                reminder.getText().get());
    }

    public static Function<TvReminder, Reminder> toReminderF() {
        return TvReminderDataConverter::toReminder;
    }
}
