package ru.yandex.reminders.logic.update;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.lang.DefaultToString;

/**
 * @author dbrylev
 */
public class ActionInfo extends DefaultToString {

    private final Instant now;
    private final String requestId;
    private final Option<String> hostId;

    public ActionInfo(Instant now, String requestId, Option<String> hostId) {
        this.now = now;
        this.hostId = hostId;
        this.requestId = requestId;
    }

    public Instant getNow() {
        return now;
    }

    public String getRequestId() {
        return requestId;
    }

    public Option<String> getHostId() {
        return hostId;
    }

    public String getRequestIdWithHostId() {
        return requestId + (hostId.isDefined() ? "_" + hostId.get() : "");
    }
}
