package ru.yandex.reminders.logic.update;

import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.function.Function0;
import ru.yandex.bolts.function.Function0V;
import ru.yandex.commune.lockservice.AcquisitionId;
import ru.yandex.commune.lockservice.ResourceId;
import ru.yandex.commune.lockservice.client.LockClient;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.reminders.api.DateTimeConverters;
import ru.yandex.reminders.logic.reminder.EventType;

/**
 * @author dbrylev
 */
public class LockManager {
    @Autowired
    private LockClient lockClient;

    public void withLock(PassportUid uid, EventType eventType, Function0V callback) {
        withLock(uid, eventType, callback.asFunction0ReturnNull());
    }

    public <A> A withLock(PassportUid uid, EventType eventType, final Function0<A> callback) {
        return withLock(userToResourceId(uid, eventType), callback);
    }

    public void withLock(ResourceId resourceId, Function0V callback) {
        withLock(resourceId, callback.asFunction0ReturnNull());
    }

    public <A> A withLock(ResourceId resourceId, final Function0<A> callback) {
        AcquisitionId acquisition = lockClient.lock(Cf.list(resourceId));
        try {
            return callback.apply();
        } finally {
            lockClient.unlock(acquisition);
        }
    }

    public static ResourceId userToResourceId(PassportUid uid, EventType eventType) {
        return new ResourceId(EventType.R.toXmlName(eventType) + ":user:" + uid);
    }

    public static ResourceId flightToResourceId(String flightNumber, int geoId, DateTimeZone tz, LocalDateTime plannedDateTime) {
        return new ResourceId(flightNumber + ":" + geoId + ":" +
                DateTimeConverters.dateTimeWithTzConverter.toString(plannedDateTime.toDateTime(tz)));
    }
}
