package ru.yandex.reminders.logic.user;

import ru.yandex.bolts.function.Function;
import ru.yandex.commune.mongo3.bender.MongoId;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author dbrylev
 */
@Bendable
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
public class Settings {
    @MongoId
    private final PassportUid uid;
    @BenderPart(name = "flightsDisabled")
    private final boolean flightRemindersDisabled;

    public Settings(PassportUid uid, boolean flightRemindersDisabled) {
        this.uid = uid;
        this.flightRemindersDisabled = flightRemindersDisabled;
    }

    public PassportUid getUid() {
        return uid;
    }

    public boolean getFlightRemindersDisabled() {
        return flightRemindersDisabled;
    }

    public static Function<Settings, Boolean> getFlightRemindersDisabledF() {
        return new Function<Settings, Boolean>() {
            public Boolean apply(Settings s) {
                return s.getFlightRemindersDisabled();
            }
        };
    }
}
