package ru.yandex.reminders.logic.user;

import ru.yandex.inside.passport.PassportUid;

/**
 * @author dbrylev
 */
public class SettingsManager {
    private SettingsDao settingsDao;

    public SettingsManager(SettingsDao settingsDao) {
        this.settingsDao = settingsDao;
    }

    public boolean flightRemindersDisabled(PassportUid uid) {
        return settingsDao.findSettings(uid).exists(Settings.getFlightRemindersDisabledF().andThenEquals(true));
    }

    public void saveFlightRemindersDisabled(PassportUid uid, boolean disabled) {
        settingsDao.saveOrUpdateSettings(new Settings(uid, disabled));
    }
}
