package ru.yandex.reminders.logic.user;

import com.mongodb.client.MongoDatabase;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.mongo3.schema.IndexInfo;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.reminders.mongodb.AbstractMdao;

/**
 * @author dbrylev
 */
public class SettingsMdao extends AbstractMdao<PassportUid, Settings> implements SettingsDao {

    public SettingsMdao(MongoDatabase remindersDb) {
        super(remindersDb, "settings", Settings.class);
    }

    @Override
    public ListF<IndexInfo> getIndexes() {
        return Cf.list();
    }

    @Override
    public void saveOrUpdateSettings(Settings settings) {
        collectionX.insertOrUpdateOne(settings);
    }

    @Override
    public Option<Settings> findSettings(PassportUid uid) {
        return collectionX.findById(uid);
    }

}
