package ru.yandex.reminders.mongodb;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import org.bson.BsonDocument;
import ru.yandex.commune.mongo3.MongoUtils;
import ru.yandex.commune.mongo3.schema.MongoCollectionIndexInfo;
import ru.yandex.inside.passport.PassportUid;

public abstract class AbstractMdao<TId, TEntity> implements MongoCollectionIndexInfo {

    protected final MongoDatabase database;
    protected final MongoCollection<BsonDocument> collection;
    protected final RemindersMongoCollectionX<TId, TEntity> collectionX;

    protected AbstractMdao(MongoDatabase db, String collectionName, Class<TEntity> entityClass) {
        this.database = db;
        this.collection = db.getCollection(collectionName, BsonDocument.class);
        this.collectionX = new RemindersMongoCollectionX<>(getCollection(), entityClass);
    }

    public void dropCollection() {
        collection.drop();
    }

    public void createIndexes() {
        getIndexes().forEach(i -> getCollection().createIndex(i.getKeys(), i.getIndexOptions()));
    }

    public void dropAndCreateCollection() {
        dropCollection();
        createIndexes();
    }

    protected static Object toMongoValue(Object some) {
        if (some instanceof PassportUid) {
            return ((PassportUid) some).getUid();
        }
        return MongoUtils.toMongoValue(some);
    }

    @Override
    public MongoCollection<BsonDocument> getCollection() {
        return collection;
    }

    public RemindersMongoCollectionX<TId, TEntity> getCollectionX() {
        return collectionX;
    }

    @Override
    public MongoDatabase getDatabase() {
        return database;
    }
}
