package ru.yandex.reminders.mongodb;

import com.mongodb.client.MongoDatabase;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import ru.yandex.commune.bazinga.context.BazingaClientContextConfiguration;
import ru.yandex.commune.bazinga.impl.storage.mongo.BazingaMongoContextConfiguration;
import ru.yandex.commune.bazinga.impl.storage.mongo.BazingaMongoDbHolder;

@Configuration
@Import({
    BazingaClientContextConfiguration.class,
    BazingaMongoContextConfiguration.class
})
public class BazingaMongoClientContextConfiguration {
    @Bean
    public BazingaMongoDbHolder bazingaMongoDbHolder(@Qualifier("bazingaDb") MongoDatabase bazingaDb) {
        return new BazingaMongoDbHolder(bazingaDb);
    }

    @Bean
    public BazingaOnetimeJobMdao bazingaOnetimeJobMdao(BazingaMongoDbHolder bazingaMongoDbHolder) {
        return new BazingaOnetimeJobMdao(bazingaMongoDbHolder);
    }
}
