package ru.yandex.reminders.mongodb;

import ru.yandex.bolts.function.Function;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

@BenderBindAllFields
public class CompressibleJsonObject {
    private final JsonObject object;

    public CompressibleJsonObject(JsonObject object) {
        this.object = object;
    }

    public JsonObject getObject() {
        return object;
    }

    public static Function<JsonObject, CompressibleJsonObject> consF() {
        return CompressibleJsonObject::new;
    }

    public static Function<CompressibleJsonObject, JsonObject> getObjectF() {
        return CompressibleJsonObject::getObject;
    }

    public static Function<CompressibleJsonObject, String> getStringF() {
        return o -> o.getObject().serialize();
    }

    public static Function<String, CompressibleJsonObject> fromStringF() {
        return s -> new CompressibleJsonObject(JsonObject.parseObject(s));
    }
}
