package ru.yandex.reminders.mongodb;

import ru.yandex.bolts.function.Function;
import ru.yandex.commune.mongo3.bender.MongoByteArrayMarshaller;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.MarshallerContext;
import ru.yandex.misc.bender.serialize.ToFieldMarshaller;
import ru.yandex.reminders.util.CompressUtils;
import ru.yandex.reminders.util.bender.JsonToFieldMarshaller;

public class CompressibleObjectMarshaller implements JsonToFieldMarshaller {

    private static final ToFieldMarshaller bytesMarshaller = new MongoByteArrayMarshaller();
    private final Function<Object, String> toStringF;

    public CompressibleObjectMarshaller(Function<?, String> toStringF) {
        this.toStringF = toStringF.uncheckedCast();
    }

    @Override
    public void writeJsonToField(BenderJsonWriter writer, Object fieldValue, MarshallerContext context) {
        bytesMarshaller.writeJsonToField(writer, compress(fieldValue), context);
    }

    @Override
    public String getJsonFieldTextValue(Object fieldValue, MarshallerContext context) {
        return bytesMarshaller.getJsonFieldTextValue(compress(fieldValue), context);
    }

    private byte[] compress(Object fieldValue) {
        return CompressUtils.compress(toStringF.apply(fieldValue));
    }
}
