package ru.yandex.reminders.mongodb;

import ru.yandex.bolts.function.Function;
import ru.yandex.commune.mongo3.bender.MongoByteArrayUnmarshaller;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.parse.FieldLevelUnmarshaller;
import ru.yandex.misc.bender.parse.ParseResult;
import ru.yandex.misc.bender.parse.UnmarshallerContext;
import ru.yandex.reminders.util.CompressUtils;
import ru.yandex.reminders.util.bender.JsonFieldLevelUnmarshaller;

public class CompressibleObjectUnmarshaller implements JsonFieldLevelUnmarshaller {
    private static final FieldLevelUnmarshaller bytesUnmarshaller = new MongoByteArrayUnmarshaller();
    private final Function<String, Object> fromStringF;

    public CompressibleObjectUnmarshaller(Function<String, ?> fromStringF) {
        this.fromStringF = fromStringF.uncheckedCast();
    }

    @Override
    public ParseResult<Object> parseJsonNode(BenderJsonNode node, UnmarshallerContext context) {
        ParseResult<byte[]> bytes = bytesUnmarshaller.parseJsonNode(node, context).cast();

        return bytes.isSuccess()
                ? ParseResult.result(fromStringF.apply(CompressUtils.decompress(bytes.getOrThrow())))
                : bytes.cast();
    }
}
