package ru.yandex.reminders.mongodb;

import ru.yandex.bolts.function.Function;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

@BenderBindAllFields
public class CompressibleString {
    private final String string;

    public CompressibleString(String string) {
        this.string = string;
    }

    public String getString() {
        return string;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        CompressibleString that = (CompressibleString) o;

        if (string != null) {
            return string.equals(that.string);
        }
        return that.string == null;
    }

    @Override
    public int hashCode() {
        return string != null ? string.hashCode() : 0;
    }

    public static Function<String, CompressibleString> consF() {
        return CompressibleString::new;
    }

    public static Function<CompressibleString, String> getStringF() {
        return CompressibleString::getString;
    }
}
