package ru.yandex.reminders.mongodb;

import org.joda.time.DateTimeZone;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.parse.ParseResult;
import ru.yandex.misc.bender.parse.UnmarshallerContext;
import ru.yandex.reminders.util.bender.JsonFieldLevelUnmarshaller;

public class DateTimeZoneUnmarshaller implements JsonFieldLevelUnmarshaller {

    @Override
    public ParseResult<Object> parseJsonNode(BenderJsonNode node, UnmarshallerContext context) {
        String value = node.getValueAsString();

        if (value.isEmpty()) {
            return ParseResult.result(null);
        }
        return ParseResult.result(DateTimeZone.forID(value));
    }
}
