package ru.yandex.reminders.mongodb;

import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.simpleType.NumberMarshaller;
import ru.yandex.misc.enums.IntEnum;

public class IntEnumMarshaller extends NumberMarshaller {

    @Override
    protected void writeJsonNotNull(BenderJsonWriter json, Object o) {
        json.writeNumber(((IntEnum) o).value());
    }

    @Override
    protected String toStringValueForXml(Object o) {
        return Integer.toString(((IntEnum) o).value());
    }
}
