package ru.yandex.reminders.mongodb;

import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.parse.ParseResult;
import ru.yandex.misc.bender.parse.UnmarshallerContext;
import ru.yandex.misc.enums.AbstractIntEnumResolver;
import ru.yandex.misc.enums.IntEnum;
import ru.yandex.reminders.util.bender.JsonFieldLevelUnmarshaller;

public class IntEnumUnmarshaller<T extends Enum<T> &IntEnum> implements JsonFieldLevelUnmarshaller {
    private final AbstractIntEnumResolver<T> resolver;

    public IntEnumUnmarshaller(AbstractIntEnumResolver<T> resolver) {
        this.resolver = resolver;
    }

    @Override
    public ParseResult<Object> parseJsonNode(BenderJsonNode node, UnmarshallerContext context) {
        String value = node.getValueAsString();

        if (value.isEmpty()) {
            return ParseResult.result(null);
        }
        return ParseResult.result(resolver.fromValue(Integer.parseInt(value)));
    }
}