package ru.yandex.reminders.mongodb;

import org.joda.time.Duration;
import ru.yandex.misc.db.PingerThread;

public class MongoCheckWorker extends PingerThread {

    private final PingerMdao pingerMdao;
    private final long delayMs;

    public MongoCheckWorker(PingerMdao pingerMdao, Duration delay) {
        super("mongo-checker", "Checks that MongoDb is available for writing.");
        this.pingerMdao = pingerMdao;
        this.delayMs = delay.getMillis();
    }

    @Override
    protected void ping() {
        pingerMdao.ping();
    }

    @Override
    protected void stateChanged(boolean available, boolean first) {
    }

    @Override
    protected long delayBetweenExecutionsMillis() {
        return delayMs;
    }
}
