package ru.yandex.reminders.mongodb;

import ru.yandex.misc.io.http.HttpStatus;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Returns last status of MongoDB pinging.
 */
public class MongoPingServlet extends HttpServlet {

    private final MongoCheckWorker mongoCheckWorker;

    public MongoPingServlet(MongoCheckWorker mongoCheckWorker) {
        this.mongoCheckWorker = mongoCheckWorker;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (mongoCheckWorker.isAvailable()) {
            resp.getWriter().write("ok /ping-mongo");
        } else {
            resp.sendError(HttpStatus.SC_500_INTERNAL_SERVER_ERROR);
        }
    }

}
