package ru.yandex.reminders.mongodb;

import com.mongodb.client.MongoDatabase;
import org.bson.BsonDocument;
import org.joda.time.Instant;
import ru.yandex.bolts.collection.Cf;
import ru.yandex.commune.mongo3.MongoCollectionX;
import ru.yandex.commune.mongo3.bender.MongoId;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.env.EnvironmentType;
import ru.yandex.misc.net.HostnameUtils;
import ru.yandex.misc.version.AppName;

/**
 * Provides single method {@link #ping()} for checking that MongoDB is available for write operations.
 */
public class PingerMdao {
    private final MongoCollectionX<String, PingStatus> pingCollection;
    private final String id;

    public PingerMdao(AppName appName, MongoDatabase remindersDb, BenderConfiguration mongoBenderConfiguration) {
        id = Cf.list(
                HostnameUtils.localHostname(),
                appName.serviceName(),
                appName.appName(),
                EnvironmentType.getActive().getValue()
        ).mkString("/");

        pingCollection = new MongoCollectionX<>(
                remindersDb.getCollection("ping", BsonDocument.class),
                PingStatus.class, mongoBenderConfiguration);
    }

    public void ping() {
        pingCollection.insertOrUpdateOne(new PingStatus(id, Instant.now()));
    }

    @Bendable
    @BenderMembersToBind(value = MembersToBind.ALL_FIELDS)
    private static class PingStatus {
        @MongoId
        private final String id;
        @BenderPart
        private final Instant ts;

        private PingStatus(String id, Instant ts) {
            this.id = id;
            this.ts = ts;
        }
    }
}
