package ru.yandex.reminders.mongodb;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.UpdateResult;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;
import ru.yandex.commune.mongo3.FiltersX;
import ru.yandex.commune.mongo3.MongoCollectionX;

public class RemindersMongoCollectionX<TId, TEntity> extends MongoCollectionX<TId, TEntity> {

    public RemindersMongoCollectionX(
            MongoCollection<BsonDocument> collection, Class<TEntity> entityClass)
    {
        super(collection, entityClass, MongoDaoContextConfiguration.mongoBenderConfiguration());
    }

    public UpdateResult replaceOneWithoutId(Bson query, TEntity entity) {
        BsonDocument document = serialize(entity);
        document.remove(FiltersX.ID_FIELD);

        return executeWithRetry(() -> getCollection().replaceOne(query, document, new UpdateOptions().upsert(true)));
    }

    public TEntity findOneAndReplaceWithoutId(Bson query, TEntity entity) {
        BsonDocument document = serialize(entity);
        document.remove(FiltersX.ID_FIELD);

        return getBender().parse(executeWithRetry(() -> getCollection().findOneAndReplace(query, document,
                new FindOneAndReplaceOptions().upsert(true).returnDocument(ReturnDocument.AFTER))));
    }
}