package ru.yandex.reminders.tvm;

import java.util.stream.Stream;

import lombok.val;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.commune.a3.action.parameter.IllegalParameterException;
import ru.yandex.passport.tvmauth.TvmToolSettings;

@Configuration
public class TvmClientConfiguration {
    @Bean(destroyMethod = "close")
    public ru.yandex.passport.tvmauth.NativeTvmClient getLibraryClient(@Value("${tvm.self.alias}") String selfAlias,
                                                                       @Value("${tvm.tool.port}") int port,
                                                                       @Value("${tvm.tool.host}") String hostname,
                                                                       @Value("${QLOUD_TVM_TOKEN}") String authToken) {
        if (Stream.of(selfAlias, hostname, authToken).anyMatch(String::isEmpty)) {
            throw new IllegalParameterException("Parameters tvm.self.alias,tvm.tool.host,QLOUD_TVM_TOKEN should not be empty");
        }

        val settings = new TvmToolSettings(selfAlias);
        settings.setPort(port);
        settings.setHostname(hostname);
        settings.setAuthToken(authToken);

        return ru.yandex.passport.tvmauth.NativeTvmClient.create(settings);
    }

    @Bean
    public TvmClient getClient(ru.yandex.passport.tvmauth.NativeTvmClient libraryClient) {
        return new TvmClientImpl(libraryClient);
    }
}