package ru.yandex.reminders.tvm;

import java.util.Optional;

import lombok.val;

import ru.yandex.passport.tvmauth.TicketStatus;

public class TvmClientImpl implements TvmClient {
    private final ru.yandex.passport.tvmauth.NativeTvmClient client;

    public TvmClientImpl(ru.yandex.passport.tvmauth.NativeTvmClient client) {
        this.client = client;
    }

    @Override
    public String getServiceTicketFor(int clientId) {
        return client.getServiceTicketFor(clientId);
    }

    @Override
    public String getServiceTicketFor(String alias) {
        return client.getServiceTicketFor(alias);
    }

    @Override
    public ServiceTicket checkServiceTicket(String ticketBody) {
        val ticket = client.checkServiceTicket(ticketBody);
        val status = ticket.getStatus();
        if (status == TicketStatus.OK) {
            return new ServiceTicket(ticket.getStatus(), Optional.of((long) ticket.getSrc()));
        }
        return new ServiceTicket(ticket.getStatus(), Optional.empty());
    }
}