package ru.yandex.reminders.tvm;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;
import ru.yandex.inside.passport.tvm2.AddServiceTicketInterceptor;
import ru.yandex.inside.passport.tvm2.ByHostClientResolver;
import ru.yandex.reminders.boot.RemindersZkContextConfiguration;

/**
 * @author dbrylev
 */
@Configuration
@Import(RemindersZkContextConfiguration.class)
public class TvmContextConfiguration {
    @Bean
    public TvmDstClientsZkRegistry tvmDstClientsZkRegistry(
            @Qualifier("zkRoot") ZkPath zkRoot, ZkManager manager) {
        TvmDstClientsZkRegistry registry = new TvmDstClientsZkRegistry(zkRoot.child("tvm-dst-clients"));

        manager.addClient(registry);
        return registry;
    }

    @Bean
    public AddServiceTicketInterceptor addServiceTicketInterceptor(
            TvmClient client, TvmDstClientsZkRegistry registry) {
        return new AddServiceTicketInterceptor(request -> ByHostClientResolver.getHost(request)
                .flatMapO(host -> registry.getO(host).map(TvmDstClientsZkRegistry.TvmDstClientInfo::getClientId))
                .map(clientId -> client.getServiceTicketFor(clientId)));
    }
}
