package ru.yandex.reminders.tvm;

import lombok.Data;

import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.primitives.registry.ZkRegistry;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author dbrylev
 */
public class TvmDstClientsZkRegistry extends ZkRegistry<String, TvmDstClientsZkRegistry.TvmDstClientInfo> {

    public TvmDstClientsZkRegistry(ZkPath zkPath) {
        super(zkPath, Bender.cons(TvmDstClientInfo.class), info -> info.host, s -> s);
    }

    @Data
    @BenderBindAllFields
    public static class TvmDstClientInfo {
        private final String host;
        private final int clientId;
    }
}
