package ru.yandex.reminders.util;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.io.gzip.GzipUtils;
import ru.yandex.misc.lang.CharsetUtils;

public class CompressUtils {

    public static byte[] compress(String message) {
        return GzipUtils.zip(message.getBytes(CharsetUtils.UTF8_CHARSET));
    }

    public static String decompress(byte[] bytes) {
        return new String(GzipUtils.unzip(bytes), CharsetUtils.UTF8_CHARSET);
    }

    public static Option<byte[]> compress(Option<String> message) {
        return message.map(CompressUtils::compress);
    }
}
