package ru.yandex.reminders.util;

import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormatter;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.convert.ConverterToType;

public abstract class DateTimeConverter<T> implements ConverterToType<T> {
    protected final DateTimeFormatter formatter;

    public DateTimeConverter(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    public abstract String toString(T d);
    public abstract T parse(String s);

    @Override
    public T convert(String s, ActionInvocationContext invocationContext) {
        return s != null ? parse(s) : null;
    }

    public static DateTimeConverter<LocalDateTime> localDateTimeConverter(DateTimeFormatter formatter) {
        return new DateTimeConverter<LocalDateTime>(formatter) {
            @Override
            public String toString(LocalDateTime d) {
                return formatter.print(d);
            }

            @Override
            public LocalDateTime parse(String s) {
                return formatter.parseLocalDateTime(s);
            }
        };
    }

    public static DateTimeConverter<DateTime> dateTimeConverter(DateTimeFormatter formatter) {
        return new DateTimeConverter<DateTime>(formatter) {
            @Override
            public String toString(DateTime d) {
                return formatter.print(d);
            }
            @Override
            public DateTime parse(String s) {
                return formatter.parseDateTime(s);
            }
        };
    }

}
