package ru.yandex.reminders.util;

import org.joda.time.*;
import ru.yandex.bolts.function.Function;

public class DateTimeUtils {
    public static DateTime toDateTimeIgnoreGap(LocalDateTime dateTime, DateTimeZone tz) {
        if (tz.isLocalDateTimeGap(dateTime)) {
            // assuming no day with more then one transition
            DateTime dayStart = dateTime.toLocalDate().toDateTimeAtStartOfDay(tz);

            return !dayStart.toLocalTime().isEqual(LocalTime.MIDNIGHT)
                    ? dayStart
                    : new DateTime(tz.nextTransition(dayStart.getMillis()), tz);
        } else {
            return dateTime.toDateTime(tz);
        }
    }

    public static Function<String, DateTimeZone> tzForIdF() {
        return DateTimeZone::forID;
    }

    public static Function<DateTimeZone, Instant> toInstantIgnoreGapF(final LocalDateTime dateTime) {
        return tz -> toDateTimeIgnoreGap(dateTime, tz).toInstant();
    }

    public static Function<Integer, Duration> minutesDurationF() {
        return Duration::standardMinutes;
    }

    public static Instant tzMigrateInstant(Instant instant, DateTimeZone tz) {
        return tz.isFixed()
                ? instant
                : new LocalDateTime(instant, DateTimeZone.forID("tz2016g/" + tz.getID())).toDateTime(tz).toInstant();
    }

    public static LocalDateTime tzMigratedInstantLocalDateTime(Instant instant, DateTimeZone tz) {
        return new LocalDateTime(tzMigrateInstant(instant, tz), tz);
    }

}
