package ru.yandex.reminders.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import lombok.val;
import ru.yandex.commune.json.*;
import ru.yandex.commune.json.bender.JsonValueMarshaller;
import ru.yandex.commune.json.bender.JsonValueUnmarshaller;
import ru.yandex.misc.bender.parse.EmptyUnmarshallerContext;
import ru.yandex.misc.bender.parse.JacksonJsonNodeWrapper;
import ru.yandex.misc.bender.serialize.BenderJsonGeneratorWrapper;
import ru.yandex.misc.bender.serialize.EmptyMarshallerContext;
import ru.yandex.misc.io.IoUtils;
import ru.yandex.misc.lang.Validate;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;

public class JsonObjectUtils {
    public static Optional<JsonObject> getObjectFieldO(JsonObject object, String field) {
        return getFieldO(object, field, JsonObject.class);
    }

    public static Optional<JsonString> getStringFieldO(JsonObject object, String field) {
        return getFieldO(object, field, JsonString.class);
    }

    public static Optional<JsonNumber> getNumberFiledO(JsonObject object, String field) {
        return getFieldO(object, field, JsonNumber.class);
    }

    public static Optional<JsonBoolean> getBooleanFieldO(JsonObject object, String field) {
        return getFieldO(object, field, JsonBoolean.class);
    }

    private static <T extends JsonValue> Optional<T> getFieldO(JsonObject object, String field, Class<T> valueClass) {
        val value = object.getO(field);
        if (value.isPresent()) {
            Validate.isTrue(valueClass.isAssignableFrom(value.get().getClass()));
            return value.toOptional().map(valueClass::cast);
        }
        return Optional.empty();
    }

    public static Optional<String> getStringFieldValueO(JsonObject object, String field) {
        val f = getStringFieldO(object, field);
        return f.map(JsonString::getString);
    }

    public static Optional<Long> getNumberFieldLongValueO(JsonObject object, String field) {
        val f = getNumberFiledO(object, field);
        return f.map(jsonNumber -> jsonNumber.getValue().longValue());
    }

    public static Optional<Boolean> getBooleanFieldValueO(JsonObject object, String field) {
        return getBooleanFieldO(object, field).map(JsonSimpleValue::getValue);
    }

    private static final ObjectMapper mapper = new ObjectMapper();

    public static JsonValue objectToJsonValue(Object value) {
        val node = mapper.valueToTree(value);
        val unmarshaller = new JsonValueUnmarshaller();

        return (JsonValue) unmarshaller.parseJsonNode(
                new JacksonJsonNodeWrapper(node), new EmptyUnmarshallerContext()).getOrThrow();
    }

    public static Object jsonObjectToObject(JsonObject value) {
        val buffer = new TokenBuffer(null, false);

        new JsonValueMarshaller().writeJsonToField(new BenderJsonGeneratorWrapper(buffer), value, new EmptyMarshallerContext());
        try {
            return mapper.readValue(buffer.asParser(), Map.class);
        } catch (IOException e) {
            throw IoUtils.translate(e);
        }
    }
}
