package ru.yandex.reminders.util;

import ru.yandex.commune.mail.MailAddress;
import ru.yandex.misc.email.Email;

import java.util.Optional;

public class MailUtils extends ru.yandex.commune.mail.MailUtils {
    public static final Email YANDEX_SENDER_EMAIL = new Email("noreply@yandex.ru");
    public static final MailAddress YANDEX_SENDER_ADDRESS = new MailAddress(YANDEX_SENDER_EMAIL);

    public static final String EMPTY_MESSAGE_ID = "<empty>";

    public static MailAddress mailAddressForSenderName(Optional<String> fromName) {
        return fromName.map(s -> new MailAddress(YANDEX_SENDER_EMAIL, s)).orElse(YANDEX_SENDER_ADDRESS);
    }
}
