package ru.yandex.reminders.util;

import lombok.val;
import org.apache.http.HttpResponse;
import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.misc.bender.parse.BenderParser;
import ru.yandex.misc.io.InputStreamSourceUtils;
import ru.yandex.misc.io.http.apache.v4.Abstract200ResponseHandler;

import java.io.IOException;

public class ReadJsonByBenderResponseHandler<T> extends Abstract200ResponseHandler<T> {
    private final BenderParser<T> parser;
    private final SetF<String> allowedContentTypes;

    public ReadJsonByBenderResponseHandler(BenderParser<T> parser, String... allowedContentTypes) {
        this.parser = parser;
        this.allowedContentTypes = Cf.set(allowedContentTypes);
    }

    @Override
    protected T handle200Response(HttpResponse response) throws IOException {
        checkContentTypeIfNeeded(response);
        val entity = response.getEntity();
        if (entity == null) {
            throw new RuntimeException("HttpResponse without entity");
        }
        return parser.parseJson(InputStreamSourceUtils.wrap(entity.getContent()));
    }

    protected void checkContentTypeIfNeeded(HttpResponse response) {
        if (allowedContentTypes.isNotEmpty()) {
            val ct = response.getFirstHeader("Content-Type");
            if (ct == null) {
                throw new RuntimeException("Content-Type header is absent in response");
            }
            if (!allowedContentTypes.containsTs(ct.getValue())) {
                throw new RuntimeException(
                        "Invalid Content-Type header: expected=" + allowedContentTypes + ", was=" + ct.getValue());
            }
        }
    }

}
