package ru.yandex.reminders.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;

public class UrlUtils extends ru.yandex.misc.io.http.UrlUtils {
    public static boolean isCorrectHttpUrl(String str) {
        return (str.startsWith("http://") || str.startsWith("https://")) && parseUrlSafe(str).isPresent();
    }

    public static Optional<URL> parseUrlSafe(String url) {
        try {
            return Optional.of(new URL(url));
        } catch (MalformedURLException e) {
            return Optional.empty();
        }
    }
}
