package ru.yandex.reminders.util;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import lombok.val;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.ThreadLocalX;
import ru.yandex.misc.bender.BenderUtils;
import ru.yandex.misc.bender.config.BenderSettings;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactory;
import ru.yandex.misc.bender.parse.FieldLevelUnmarshaller;
import ru.yandex.misc.bender.parse.JacksonJsonNodeWrapper;
import ru.yandex.misc.bender.parse.MainUnmarshallerFactory;
import ru.yandex.misc.bender.parse.Unmarshaller;
import ru.yandex.misc.bender.serialize.MainMarshallerFactory;
import ru.yandex.misc.bender.serialize.Marshaller;
import ru.yandex.misc.lang.Check;
import ru.yandex.misc.reflection.TypeX;
import ru.yandex.reminders.util.bender.JsonFieldLevelUnmarshaller;

public class ValueOrObjectMarshallerUnmarshallerFactory implements CustomMarshallerUnmarshallerFactory {
    private final ThreadLocalX<TypeX> customizing = new ThreadLocalX<>();

    @Override
    public Option<Unmarshaller> createCustomUnmarshaller(BenderSettings settings,
                                                         MainUnmarshallerFactory mainUnmarshallerFactory, TypeX type) {
        if (customizing.getO().isPresent()) {
            Check.some(type, customizing.getO());

            customizing.remove();
            return Option.empty();
        }
        if (!type.isClass() || !BenderUtils.hasBendable(type.asClass())) {
            return Option.empty();
        }
        val field = type.asClass().getDeclaredInstanceFields().find(f -> f.hasAnnotation(BindValueNodeHere.class));

        if (!field.isPresent()) {
            return Option.empty();
        }

        customizing.set(type);

        val originalUnmarshaller = (FieldLevelUnmarshaller) mainUnmarshallerFactory.createUnmarshaller(type);

        return Option.of((JsonFieldLevelUnmarshaller) (node, context) -> {
            if (node.isValueNode()) {
                node = new JacksonJsonNodeWrapper(JsonNodeFactory.instance.objectNode()
                        .put(field.get().getName(), node.getValueAsString()));
            }
            return originalUnmarshaller.parseJsonNode(node, context);
        });
    }

    @Override
    public Option<Marshaller> createCustomMarshaller(BenderSettings settings,
                                                     MainMarshallerFactory mainMarshallerFactory, TypeX type) {
        return Option.empty();
    }
}
