package ru.yandex.reminders.util.jsonld;

import org.joda.time.Duration;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import ru.yandex.bolts.collection.Either;
import ru.yandex.bolts.function.Function;
import ru.yandex.misc.time.TimeUtils;

import java.util.Optional;

public class ExtractedEventData {
    private final Optional<String> name;
    private final Optional<String> description;

    private final Optional<String> url;
    private final Optional<String> image;

    private final Optional<Either<LocalDate, LocalDateTime>> start;
    private final Optional<Either<LocalDate, LocalDateTime>> end;
    private final Optional<Duration> duration;

    public ExtractedEventData(
            Optional<String> name, Optional<String> description,
            Optional<String> url, Optional<String> image,
            Optional<Either<LocalDate, LocalDateTime>> start,
            Optional<Either<LocalDate, LocalDateTime>> end,
            Optional<Duration> duration) {
        this.name = name;
        this.description = description;
        this.url = url;
        this.image = image;
        this.start = start;
        this.end = end;
        this.duration = duration;
    }

    public static ExtractedEventData empty() {
        return new ExtractedEventData(
                Optional.empty(), Optional.empty(),
                Optional.empty(), Optional.empty(),
                Optional.empty(),
                Optional.empty(),
                Optional.empty());
    }

    public Optional<String> getName() {
        return name;
    }

    public Optional<String> getDescription() {
        return description;
    }

    public Optional<String> getUrl() {
        return url;
    }

    public Optional<String> getImage() {
        return image;
    }

    public Optional<Either<LocalDate, LocalDateTime>> getStart() {
        return start;
    }

    public Optional<Either<LocalDate, LocalDateTime>> getEnd() {
        return end;
    }

    public Optional<LocalDate> getStartDate() {
        return getDate(getStart());
    }

    public Optional<LocalDate> getEndDate() {
        return getDate(getEnd());
    }

    public Optional<LocalTime> getStartTime() {
        return getTime(getStart());
    }

    public Optional<LocalTime> getEndTime() {
        return getTime(getEnd());
    }

    public Optional<Duration> getDuration() {
        return duration;
    }

    private Optional<LocalDate> getDate(Optional<Either<LocalDate, LocalDateTime>> either) {
        return either.map(localDateLocalDateTimeEither -> localDateLocalDateTimeEither.fold(Function.identityF(), TimeUtils.localDateTime.localDateF()));
    }

    private Optional<LocalTime> getTime(Optional<Either<LocalDate, LocalDateTime>> either) {
        return either.isPresent() && either.get().isRight()
                ? either.map(v -> v.getRight().toLocalTime())
                : Optional.empty();
    }
}
