package ru.yandex.reminders.util.jsonld;

import com.github.jsonldjava.core.DocumentLoader;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import org.apache.commons.lang.NotImplementedException;
import org.apache.http.client.HttpClient;
import ru.yandex.commune.json.JsonObject;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.reminders.util.JsonObjectUtils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;

public class SchemaOrgJsonLdProcessor {
    private static final String SCHEMA_ORG_CONTEXT = "{\"@context\":{\"@vocab\":\"http://schema.org/\"}}";
    private static final String NOT_SCHEMA_ORG_CONTEXT = "{\"@context\":{\"@vocab\":\":x($)/\"}}";

    public static JsonObject compact(JsonObject object) {
        try {
            JsonLdOptions options = new JsonLdOptions();
            options.setDocumentLoader(new HackedContextDocumentLoader());

            return (JsonObject) JsonObjectUtils.objectToJsonValue(com.github.jsonldjava.core.JsonLdProcessor.compact(
                    JsonObjectUtils.jsonObjectToObject(object),
                    JsonObjectUtils.jsonObjectToObject(JsonObject.parseObject(SCHEMA_ORG_CONTEXT)), options));

        } catch (JsonLdError e) {
            throw ExceptionUtils.translate(e);
        }
    }

    private static class HackedContextDocumentLoader extends DocumentLoader {
        @Override
        public HttpClient getHttpClient() {
            throw new NotImplementedException("not going to follow external urls");
        }

        @Override
        public InputStream openStreamFromURL(URL url) {
            return url.toExternalForm().equals("http://schema.org")
                    ? new ByteArrayInputStream(SCHEMA_ORG_CONTEXT.getBytes())
                    : new ByteArrayInputStream(NOT_SCHEMA_ORG_CONTEXT.replace("$", url.toExternalForm()).getBytes());
        }
    }
}
