package ru.yandex.reminders.util.task;

import org.joda.time.Duration;

public class DemoTask extends ManualTaskSupport {
    private final Duration sleepDuration;
    private final boolean returnWithSuccess;

    public DemoTask(Duration sleepDuration, boolean returnWithSuccess) {
        this.sleepDuration = sleepDuration;
        this.returnWithSuccess = returnWithSuccess;
    }

    @Override
    protected void doExecute() {
        try {
            Thread.sleep(sleepDuration.getMillis());
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        setStatus(returnWithSuccess ? TaskStatus.success(getStarted(), "ok") : TaskStatus.fail(getStarted(), "err"));
    }
}
