package ru.yandex.reminders.util.task;

import org.joda.time.Duration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ManualTaskContextConfiguration {
    @Bean
    public ManualTaskLauncher manualTaskLauncher(ApplicationContext applicationContext) {
        return new ManualTaskLauncher(applicationContext);
    }

    @Bean
    public DemoTask wait10SecThenOk() {
        return new DemoTask(Duration.standardSeconds(10), true);
    }

    @Bean
    public DemoTask wait20SecThenFail() {
        return new DemoTask(Duration.standardSeconds(20), false);
    }

    @Bean
    public TimeZoneMigrationTask timeZoneMigrationTask() {
        return new TimeZoneMigrationTask();
    }
}
