package ru.yandex.reminders.util.task;

import org.joda.time.Instant;

import ru.yandex.misc.lang.Check;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public abstract class ManualTaskSupport implements ManualTask {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private volatile boolean running = false;
    private volatile boolean stopped = false;
    private volatile TaskStatus taskStatus;
    private volatile Instant started;

    @Override
    public void execute() {
        Check.isFalse(running);
        stopped = false;
        started = Instant.now();
        setStatus(TaskStatus.running(started, "just started"));
        try {
            running = true;
            doExecute();
        } finally {
            running = false;
        }
    }

    protected abstract void doExecute();

    @Override
    public void stop() {
        stopped = true;
        setStatus(TaskStatus.stopped(started, "was stopped by user request"));
    }

    @Override
    public TaskStatus getStatus() {
        return taskStatus;
    }

    protected boolean isStopped() {
        return stopped;
    }

    protected void checkStopped() {
        if (stopped) {
            throw new StoppedException();
        }
    }

    protected void setStatus(TaskStatus taskStatus) {
        logger.debug(taskStatus);
        this.taskStatus = taskStatus;
    }

    protected Instant getStarted() {
        return started;
    }

    protected static class StoppedException extends RuntimeException {
        protected StoppedException() {
        }
    }
}
