package ru.yandex.reminders.util.task;

import ru.yandex.bolts.function.Function0V;

import java.util.concurrent.atomic.AtomicInteger;

public class TaskThread extends Thread {
    private static final AtomicInteger threadNum = new AtomicInteger(0);

    private final String taskBeanName;
    private final ManualTask manualTask;

    public TaskThread(String taskBeanName, ManualTask manualTask, Runnable target) {
        super(target, taskBeanName + '-' + threadNum.incrementAndGet());
        this.taskBeanName = taskBeanName;
        this.manualTask = manualTask;
    }

    public ManualTask getManualTask() {
        return manualTask;
    }

    public String getTaskBeanName() {
        return taskBeanName;
    }

    public String stopTask() {
        return applyAndCheckDead("stop", () -> getManualTask().stop());
    }

    public String killTask() {
        return applyAndCheckDead("kill", this::interrupt);
    }

    protected String applyAndCheckDead(String operationName, Function0V operationF) {
        operationF.apply();
        try {
            join(2000);
            if (isAlive()) {
                return String.format("Can't %s task %s within 2 secs.", operationName, taskBeanName);
            } else {
                return String.format("Task %s was %sed.", taskBeanName, operationName);
            }
        } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return String.format("Result of %s operation is unknown.", operationName);
    }

}
