package ru.yandex.reminders.worker;

import org.joda.time.Duration;
import ru.yandex.commune.bazinga.scheduler.CronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.ScheduleCron;
import ru.yandex.misc.time.TimeUtils;
import ru.yandex.reminders.logic.flight.airport.AirportManager;

public class AirportsImportTask extends CronTask {

    private final AirportManager airportManager;
    private final Duration timeout;

    public AirportsImportTask(AirportManager airportManager, Duration timeout) {
        this.airportManager = airportManager;
        this.timeout = timeout;
    }

    @Override
    public Schedule cronExpression() {
        return ScheduleCron.parse("0 4 * * *", TimeUtils.EUROPE_MOSCOW_TIME_ZONE);
    }

    @Override
    public Duration timeout() {
        return timeout;
    }

    @Override
    public void execute(ExecutionContext executionContext) {
        airportManager.importAirports();
    }
}