package ru.yandex.reminders.worker;

import lombok.val;
import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import ru.yandex.commune.bazinga.impl.TaskId;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTask;
import ru.yandex.reminders.logic.cloudApi.CloudApiClient;
import ru.yandex.reminders.logic.event.Event;
import ru.yandex.reminders.logic.event.EventMdao;
import ru.yandex.reminders.logic.event.EventsFilter;
import ru.yandex.reminders.logic.event.SpecialClientIds;
import ru.yandex.reminders.logic.reminder.Channel;
import ru.yandex.reminders.logic.reminder.EventType;
import ru.yandex.reminders.logic.reminder.Reminder;
import ru.yandex.reminders.logic.update.LockManager;

public class DeleteCloudApiFlightsTask extends OnetimeTask {
    public static final TaskId TASK_ID = new TaskId("delete-cloud-api-flights");

    @Autowired
    private LockManager lockManager;
    @Autowired
    private CloudApiClient cloudApiClient;
    @Autowired
    private EventMdao eventMdao;

    public DeleteCloudApiFlightsTask() {
        super(DeleteCloudApiFlightsTaskParameters.class);
    }

    public DeleteCloudApiFlightsTask(DeleteCloudApiFlightsTaskParameters parameters) {
        this();
        setParameters(parameters);
    }

    @Override
    public TaskId id() {
        return TASK_ID;
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(5);
    }

    @Override
    public void execute(ExecutionContext context) {
        val params = (DeleteCloudApiFlightsTaskParameters) getParameters();

        lockManager.withLock(params.getUid(), EventType.FLIGHT, () -> {
            val events = eventMdao.findEvents(EventsFilter.byExternalId(params.getExternalId())
                    .toMongoQuery(params.getUid(), SpecialClientIds.FLIGHT));

            val eventByIdx = events.toMapMappingToKey(Event::getIdx);

            params.getIdxsToBeDeleted().stream()
                    .filter(idx -> !eventByIdx.getO(idx)
                            .exists(e -> e.getReminders()
                            .exists(Reminder.channelIsF(Channel.CLOUD_API))))
                    .forEach(idx -> cloudApiClient.deleteFlight(params.getUid(), params.getExternalId() + "." + idx));
        });
    }
}
