package ru.yandex.reminders.worker;

import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;

import java.util.List;

@Bendable
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
public class DeleteCloudApiFlightsTaskParameters {
    private final PassportUid uid;
    private final String extId;
    private final List<Long> idxs;

    public DeleteCloudApiFlightsTaskParameters(PassportUid uid, String externalId, List<Long> idxsToBeDeleted) {
        this.uid = uid;
        this.extId = externalId;
        this.idxs = idxsToBeDeleted;
    }

    public PassportUid getUid() {
        return uid;
    }

    public String getExternalId() {
        return extId;
    }

    public List<Long> getIdxsToBeDeleted() {
        return idxs;
    }
}