package ru.yandex.reminders.worker;

import org.bson.types.ObjectId;
import org.joda.time.Instant;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;

@Bendable
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
public class FlightShiftSendTaskParameters {
    private final ObjectId flightShiftId;

    private final Instant submitTs;
    private final String submitReq;

    public FlightShiftSendTaskParameters(ObjectId flightShiftId, Instant submitTs, String submitReq) {
        this.flightShiftId = flightShiftId;
        this.submitTs = submitTs;
        this.submitReq = submitReq;
    }

    public ObjectId getFlightShiftId() {
        return flightShiftId;
    }
}
