package ru.yandex.reminders.worker;

import org.bson.types.ObjectId;
import org.joda.time.Instant;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;
import ru.yandex.reminders.logic.event.EventId;

@Bendable
@BenderMembersToBind(MembersToBind.ALL_FIELDS)
public class ReminderSendTaskParameters {
    private final EventId eventId;
    private final ObjectId reminderId;

    private final Instant submitTs;
    private final String submitReq;

    public ReminderSendTaskParameters(EventId eventId, ObjectId reminderId, Instant submitTs, String submitReq) {
        this.eventId = eventId;
        this.reminderId = reminderId;
        this.submitTs = submitTs;
        this.submitReq = submitReq;
    }

    public EventId getEventId() {
        return eventId;
    }

    public ObjectId getReminderId() {
        return reminderId;
    }
}
