package ru.yandex.reminders.worker;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.MembersToBind;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderMembersToBind;

import java.util.Optional;

public class ReminderSentInfo {

    public static Sent sent(Optional<String> messageId) {
        return new Sent(messageId);
    }

    public static Failed failed(String reason) {
        return new Failed(reason);
    }

    @Bendable
    @BenderMembersToBind(MembersToBind.ALL_FIELDS)
    public static class Sent {
        private final String status = "sent";
        private final Optional<String> msgId;

        public Sent(Optional<String> msgId) {
            this.msgId = msgId;
        }
    }

    @Bendable
    @BenderMembersToBind(MembersToBind.ALL_FIELDS)
    public static class Failed {
        private final String status = "failed";
        private final String reason;

        public Failed(String reason) {
            this.reason = reason;
        }
    }
}
