importPackage(com.mongodb);
importPackage(org.joda.time);
importPackage(ru.yandex.commune.mongo);
importPackage(ru.yandex.reminders.logic.event);
importPackage(ru.yandex.misc.io.http.apache.v4);
importPackage(org.joda.time.format);

importPackage(java.util);
importPackage(ru.yandex.misc.io);
importPackage(ru.yandex.misc.lang);
importPackage(ru.yandex.misc.regex);
importPackage(ru.yandex.misc.email);
importPackage(ru.yandex.commune.json);
importPackage(ru.yandex.commune.json.serialize);
importPackage(org.apache.commons.lang);

f = function(func) { return new F() { apply:function x(a) { return func(a); } } };
f1B = function(func) { return Function1B.wrap(f(func)); };
f1V = function(func) { return f(func).ignoreResult(); };
f0 = function(func) { return new ru.yandex.bolts['function'].Function0() { apply:function x() { return func(); }} };
f2V = function(func) { return new ru.yandex.bolts['function'].Function2V() { apply:function x(a, b) { return func(a, b); }} };
bind = function(func, arg1) { return function(arg2, arg3) { return func(arg1, arg2, arg3) }};

invoke = function(clazz, obj, name, varargs) {
    var method = ru.yandex.misc.reflection.MethodX.getSingleMethod(clazz, name);
    method.setAccessible(true);
    return method.invoke(obj, [].slice.call(arguments, 3));
};

getFoundFlightEventsIter = function() {
    var matchOp = BasicDBObjectBuilder
            .start()
            .push("$match")
                .add("cid", "yandex-flight")
                .push("flight.depTs")
                    .add("$gt", ru.yandex.commune.mongo.MongoUtils.toMongoValue(DateTime.now()))
                .pop()
            .pop()
            .get();
    var groupOp = BasicDBObjectBuilder
            .start()
            .push("$group")
                .push("_id")
                    .add("n", "$flight.num")
                    .add("a", "$flight.depAirport")
                    .add("d", "$flight.depTs")
                    .add("tz", "$flight.depTz")
                .pop()
            .pop()
            .get();
    var sortOp = BasicDBObjectBuilder
            .start()
            .push("$sort")
                .add("_id.n", 1)
                .add("_id.d", 1)
                .add("_id.tz", 1)
            .pop()
            .get();

    return invoke(ru.yandex.reminders.mongodb.AbstractMdao, eventMdao, "getCollection")
            .aggregate(matchOp, groupOp, sortOp).results().iterator();
};

toFlightsByFlightNumMap = function(flightsIter) {
    var result = Cf.hashMap();
    while (flightsIter.hasNext()) {
        var id = flightsIter.next().get("_id");
        var num = id.get("n");
        var flights = result.get(num);
        if (flights == null) {
            flights = Tuple3List.arrayList();
            result.put(num, flights);
        }
        flights.add(id.get("d"), id.get("tz"), id.get("a"))
    }
    return result;
};

printKeyValue = function(k, v) {
    print(k + " => " + v)
};

checkTimeZone = function(flightsByNumMap) {
    var flightsWithMoreThan2Tz = flightsByNumMap.mapValues(Cf.mapF(Tuple3.get2F()).andThen(Cf.uniqueF()))
            .filterValues(Cf.sizeF().andThen(Cf.Integer.gtF(java.lang.Integer.valueOf(1))));
    if (flightsWithMoreThan2Tz.isNotEmpty()) {
        print("* Reminders DB Check1: ERROR: found flights with same number, but different TimeZone");
        print("====");
        flightsWithMoreThan2Tz.forEachEntry(f2V(printKeyValue));
        print("====");
        print("Total flights with problem: " + flightsWithMoreThan2Tz.size());
    } else {
        print("* Reminders DB Check1: OK: Flights with same number, but different TimeZone not found");
    }
};

client = ApacheHttpClient4Utils.singleConnectionClient(
        ru.yandex.misc.io.http.Timeout.seconds(5), Option.some("CalendarRemindersRhinoScript"));
jodaToQueryFormatter = ISODateTimeFormat.dateTimeNoMillis();
responseToJodaFormatter = new DateTimeFormatterBuilder()
            .appendYear(4, 4)
            .appendLiteral('-')
            .appendMonthOfYear(2)
            .appendLiteral('-')
            .appendDayOfMonth(2)
            .appendLiteral(' ')
            .appendHourOfDay(2)
            .appendLiteral(':')
            .appendMinuteOfHour(2)
            .appendLiteral(':')
            .appendSecondOfMinute(2)
            .appendLiteral(' ')
            .appendTimeZoneOffset("UTC", false, 4, 4)
            .toFormatter().withOffsetParsed();
departureLocalDtProblemsCount = 0;
departureDtProblemsCount = 0;
raspEmptyResponsesCount = 0;
totalFlightCheckedCount = 0;
departureDtOfEmptyResponses = Cf.hashSet();

printDateProblem = function(flightNum, prefix, remindDt, raspDt, func, iataDescStr) {
    if (departureLocalDtProblemsCount == 0 && departureDtProblemsCount == 0) {
        print("* Reminders DB Check2: ERROR: found differences of departure local time in Reminders and Rasp");
        print("====");
    }
    if (!"".equals(iataDescStr)) {
        iataDescStr = "; IATA warning: " + iataDescStr;
    }
    print(ru.yandex.misc.lang.StringUtils.leftPad(flightNum, 6)
            + ": " + prefix
            + ": REMINDERS=" + ru.yandex.misc.lang.StringUtils.rightPad(remindDt, 29)
            + ", RASP=" + ru.yandex.misc.lang.StringUtils.rightPad(raspDt, 29)
            + ", diff=" + new Duration(func(remindDt).toDateTime(DateTimeZone.UTC),
                func(raspDt).toDateTime(DateTimeZone.UTC)).getStandardMinutes() + " mins"
            + iataDescStr);
};

checkFlightInRasp = function(flightNum, flightInfoTuple) {
    var dt = flightInfoTuple.get1();
    var tz = flightInfoTuple.get2();
    var airportName = flightInfoTuple.get3();
    var jodaDt = new DateTime(dt, DateTimeZone.forID(tz));
    var jodaLocalDt = jodaDt.toLocalDateTime();
    var jodaLocalStr = jodaToQueryFormatter.print(jodaLocalDt);

    var url = "http://raspw.corba.yandex.net/api/route/?number=" + flightNum + "&date=" + jodaLocalStr;

    var iataDescStr = "";
    if (airportName != null) {
        var iataCodes = airportManager.getIataCodesForAirportName(airportName);
        if (iataCodes.isNotEmpty()) {
            url += "&from=" + iataCodes.first();
            if (iataCodes.size() > 1) {
                iataDescStr = "more than 1 IATAs for airport='" + airportName + "', 1-st one is used, IATAs=" + iataCodes;
            } else {
                iataDescStr = "";
            }
        } else {
            iataDescStr = "without IATA: no airport='" + airportName + "' in our airports.txt";
        }
    } else {
        iataDescStr = "without IATA: no depAirport in DB";
    }
    var response = ApacheHttpClient4Utils.executeReadString(new org.apache.http.client.methods.HttpGet(url));
    totalFlightCheckedCount++;
    if (response.equals("{}")) {
        raspEmptyResponsesCount++;
        departureDtOfEmptyResponses.add(jodaDt);
        return;
    }
    var responseObj = eval('(' + response + ')');
    if (responseObj.error != null) {
        print("RASP error=[" + responseObj.error + "] for url=" + url);
        return;
    }
    var jodaDtFromRasp = responseToJodaFormatter.parseDateTime(responseObj.scheduled_departure);

    if (!jodaDt.toLocalDateTime().equals(jodaDtFromRasp.toLocalDateTime())) {
        printDateProblem(flightNum, "local  time  differs", jodaDt, jodaDtFromRasp,
                function (x) {return x.toLocalDateTime();}, iataDescStr);
        departureLocalDtProblemsCount++;
        return;
    }
    if (!jodaDt.toDateTime(DateTimeZone.UTC).equals(jodaDtFromRasp.toDateTime(DateTimeZone.UTC))) {
        printDateProblem(flightNum, "time with tz differs", jodaDt, jodaDtFromRasp,
                function (x) {return x;}, iataDescStr);
        departureDtProblemsCount++;
        return;
    }
    if (!"".equals(iataDescStr)) {
        print("IATA warning: " + iataDescStr);
    }
};

checkFlightsInRasp = function(flightNum, listOfFlightInfoTuples) {
    var boundFunc = bind(checkFlightInRasp, flightNum);
    listOfFlightInfoTuples.forEach(f1V(boundFunc));
};

checkFlightsMapInRasp = function(flightsByNumMap) {
    flightsByNumMap.forEachEntry(f2V(checkFlightsInRasp));
    if (departureLocalDtProblemsCount == 0 && departureDtProblemsCount == 0) {
        print("* Reminders DB Check2: OK: Departure local time problems was not found");
    } else {
        print("====");
    }
    if (departureLocalDtProblemsCount > 0) {
        print("Total departure  local  time problems: " + departureLocalDtProblemsCount);
    }
    if (departureDtProblemsCount > 0) {
        print("Total departure time with tz problems: " + departureDtProblemsCount);
    }
    if (raspEmptyResponsesCount > 0) {
        print("* RASP responded with empty response: " + raspEmptyResponsesCount + " times");
        print("  Min of departure time for empty responses:" + departureDtOfEmptyResponses
                .min(ru.yandex.bolts['function'].forhuman.Comparator.naturalComparator()));
    }
    print("Totally checked: " + totalFlightCheckedCount + " flights");
};


/* main() */

start = java.lang.System.currentTimeMillis();

flightsByNumMap = toFlightsByFlightNumMap(getFoundFlightEventsIter());

checkTimeZone(flightsByNumMap);
checkFlightsMapInRasp(flightsByNumMap);

print("Script took " + (java.lang.System.currentTimeMillis() - start) + " msec");

"The end. Bye."
