JAVA_PROGRAM(reminders)

IF(JDK_VERSION == "")
    JDK_VERSION(11)
ENDIF()

OWNER(
    g:calendar-back
)

NO_LINT()

RUN_JAVA_PROGRAM(
    ru.yandex.calendar.genversion.GenVersion mail/reminders ${BINDIR}/generated version.properties
    OUT_DIR ${BINDIR}/generated
    CLASSPATH mail/java/generate_version
)

PEERDIR(
    iceberg/bolts
    iceberg/commune
    iceberg/commune-a3
    iceberg/commune-a3-admin
    iceberg/commune-admin
    iceberg/commune-admin-all
    iceberg/commune-alive
    iceberg/commune-bazinga
    iceberg/commune-dynproperties
    iceberg/commune-json
    iceberg/commune-lockservice
    iceberg/commune-mail
    iceberg/commune-mongo3
    iceberg/commune-rpc
    iceberg/commune-script
    iceberg/commune-zk
    iceberg/commune-zk-admin
    iceberg/commune-zk-registry

    iceberg/inside-client-utils
    iceberg/inside-conductor
    iceberg/inside-passport
    iceberg/inside-passport-tvm2

    iceberg/misc
    iceberg/misc-apache-http-client-4
    iceberg/misc-bender
    iceberg/misc-bender-annotations
    iceberg/misc-db
    iceberg/misc-http-client-common
    iceberg/misc-jetty
    iceberg/misc-main
    iceberg/misc-spring
    iceberg/misc-worker
    iceberg/misc-xml

    contrib/java/org/jdom/jdom/1.1
    contrib/java/org/dom4j/dom4j/2.1.0
    contrib/java/jaxen/jaxen/1.1.1
    contrib/java/net/sf/saxon/saxonpe/9.2.0.6

    contrib/java/commons-lang/commons-lang/2.6
    contrib/java/commons-codec/commons-codec/1.6

    contrib/java/org/springframework/spring-beans/4.3.2.RELEASE
    contrib/java/org/springframework/spring-context/4.3.2.RELEASE
    contrib/java/org/springframework/spring-core/4.3.2.RELEASE
    contrib/java/org/springframework/spring-jdbc/4.3.2.RELEASE
    contrib/java/org/springframework/spring-tx/4.3.2.RELEASE
    contrib/java/org/springframework/spring-web/4.3.2.RELEASE
    contrib/java/org/springframework/spring-test/4.3.2.RELEASE

    contrib/java/joda-time/joda-time/2.5
    contrib/java/joda-time/tzdata/2016j+2016g

    contrib/java/com/fasterxml/jackson/core/jackson-core/2.9.5
    contrib/java/com/fasterxml/jackson/core/jackson-databind/2.9.5
    contrib/java/com/fasterxml/jackson/core/jackson-annotations/2.9.5
    contrib/java/com/fasterxml/jackson/datatype/jackson-datatype-joda/2.9.5

    contrib/java/com/github/jsonld-java/jsonld-java/0.4.1

    contrib/java/javax/servlet/javax.servlet-api/3.1.0
    contrib/java/javax/mail/mail/1.4.3

    contrib/java/junit/junit/4.12
    contrib/java/org/mockito/mockito-core/1.8.5

    contrib/java/log4j/log4j/1.2.17
    contrib/java/org/slf4j/slf4j-log4j12/1.6.1
    contrib/java/org/apache/logging/log4j/log4j-api/2.5
    contrib/java/org/apache/logging/log4j/log4j-core/2.5

    contrib/java/org/apache/httpcomponents/httpcore/4.3.3
    contrib/java/org/apache/httpcomponents/httpclient/4.3.5

    contrib/java/com/google/code/findbugs/jsr305/3.0.0
    mail/java/oauth
    mail/java/bazinga_workers
    contrib/java/org/projectlombok/lombok/1.18.22
    contrib/java/io/netty/netty-all/4.1.22.Final

    kinopoisk/libs/java/micrometer-registry-yasm
    contrib/java/io/micrometer/micrometer-core/1.0.6
    contrib/java/org/assertj/assertj-core/3.12.0
    contrib/java/one/util/streamex/0.6.7

    library/java/tvmauth
)

ANNOTATION_PROCESSOR(
    lombok.launch.AnnotationProcessorHider$AnnotationProcessor
)

EXCLUDE(
    contrib/java/net/sf/saxon/saxonhe
    contrib/java/javax/servlet/javax.servlet-api
    contrib/java/idea-annotations/idea-annotations
    contrib/java/javax/servlet/servlet-api
    contrib/java/org/mongodb/mongo-java-driver/2.13.0
    contrib/java/io/netty
)

JAVA_SRCS(SRCDIR src/main/java **/*)
JAVA_SRCS(
    SRCDIR ${BINDIR}/generated **/version.properties
    PACKAGE_PREFIX ru.yandex.reminders
)

END()

RECURSE(
    it-large
    ut-medium
)
