#!/bin/bash

logfile="/var/log/$QLOUD_APPLICATION/access.log"

ts=$(date +%s)

timetail -n 60 -r '^tskv	tskv_format=rcache-access-log	timestamp=(\d\d\d\d-\d\d-\d\d \d\d:\d\d:\d\d)' "$logfile" | \
    awk -F $'\t' -v ts="$ts" '
    @include "/usr/share/yandex-mail-common/metrics-util.awk"

    BEGIN {
        metrics["http.codes.total.200"] = 0
        metrics["http.codes.total.500"] = 0
    }

    /request=/ {
        metrics["http.total"]++

        code = "unknown"
        request = ""
        exec_time = 0
        x_request_attempt = ""

        for (i=1; i <= NF; i++) {
            if ($i ~ /^status_code=/) {
                code = substr($i, 13)
            } else if ($i ~ /^request=/) {
                offset = length("request=") + 1
                end = index($i,"?")
                end = end > 0 ? end - offset : length($i)
                request = substr($i, offset, end)
                if (request ~ "/ping") next
                gsub("^(/)*","",request)
                gsub("[/]","_",request)
            } else if ($i ~ /^profiler_exec=/) {
                exec_time = substr($i, 15)
            } else if ($i ~ /^x_request_attempt=/) {
                x_request_attempt = substr($i, length("x_request_attempt=")+1)
            }
        }

        if (x_request_attempt != "") {
            metrics["http.attempts."x_request_attempt]++
        }

        metrics["http.codes.total."code]++
        metrics["http.codes."request"."code]++
        collect_timings(exec_time, "http.timings.total", metrics)
        collect_timings(exec_time, "http.timings."request, metrics)
    }

    END {
        for (i in metrics) {
            value = metrics[i]
            if (i ~ /timings/) value = "["value"]"
            print i, value, ts
        }
    }
'