package main

import (
	"net/http"
	"strings"
	"time"
)

type Ammo struct {
	Tag string
	URI string
}

func makeTimestamp() string {
	return time.Now().Format("15:04:05.000000")
}

func (g *Gun) makeReq(ammo *Ammo) *http.Request {
	req, _ := http.NewRequest("GET", strings.Join([]string{"http://", g.conf.Target, ammo.URI}, ""), nil)
	req.Header.Add("Content-Type", "application/x-www-form-urlencoded")
	req.Header.Add("Connection", "close")
	req.Header.Add("x-real-ip", "127.0.0.1")
	req.Header.Add("X-Request-Id", makeTimestamp()+"_"+ammo.Tag)
	return req
}
